'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) 2004  Microsoft Corporation.  All rights reserved.
'***********************************************************************
Function ReACLSite(strRootFolder,strSourceServer,strOldUser,strNewUser,bRemoveOld)
' Get the Current Folder List into a Dictionary
' we only care about Folders, Files should inherit the ACLs from the Folder
' we will only go in and add the new user by default. set bRemoveOld to True
' if you want to remove the user from the ACL
Dim sec
Dim oSD
Dim oDacl
Dim oAce
Dim oTrustee
Dim tName
' Verify the Target Folder exists
If not fso.FolderExists(strRootFolder) Then
    write "The specified Folder " & strRootFolder & " could not be found. Changing ACLs will be skipped."
    Exit Function
End if
write "Reacling Folder " & StrRootFolder
Set sec = CreateObject("ADsSecurity")
' get the AccessMask for the old User
Set oSD = sec.GetSecurityDescriptor("FILE://" & strRootFolder)
Set oDacl = oSD.DiscretionaryAcl 

'-- Show the ACEs in the DACL ---- 
For Each oace In odacl 
   ' now check if we have a SID of the Trustee or the Name
   tName = oAce.Trustee
   If Left (tName,2) = "S-" then 
	   If GetSID(strSourceServer,strOldUser)= tName Then
	   		WScript.echo oace.Trustee & "|" & oace.AccessMask & "|" & oace.AceType
	   		' now add the new user with the same accessmask and acetype
	   		Set newAce = CreateObject("AccessControlEntry")
	   		newAce.Trustee = strNewUser
	   		newAce.AccessMask = oAce.AccessMask
	   		newAce.AceType = oAce.AceType
	   		oDacl.addAce newAce
	   		oSD.DiscretionaryAcl = oDacl
	   		sec.SetSecurityDescriptor oSd
	   Else
	   		WScript.StdOut.WriteLine oAce.Trustee
	   End If
	Else
		' do name checking here later
	
	End if
Next 
End Function

' get the SID of a User in a Given Domain
' Note that strDomain can also be a computername
Function GetSID(strDomain,strAlias)
Dim ADS_SID_SDDL,ADS_SID_WINNT_PATH
Dim sid
Dim sidText
ADS_SID_SDDL = 4
ADS_SID_WINNT_PATH = 5 
Set sid = CreateObject("ADsSID") 
sid.SetAs ADS_SID_WINNT_PATH, "WinNT://" & strDomain & "/" & strAlias
sidText = sid.GetAs(ADS_SID_SDDL) 
GetSID = sidText

End Function
